#include "devcoons-streaming.h"

	using namespace cv;

	using namespace std;


	void devcoonsStreaming::ImageFormatting(Mat * source,Mat * destination)
	{
		
		cv::cvtColor(*source, *destination, cv::COLOR_BGR2GRAY);
		
		(*source).convertTo(*destination,	CV_16UC1 );
		
	}
	
	
	void * devcoonsStreaming::VideoToFrames(void * threadid)
	{
		#ifdef STREAMING_DEBUG

			printf(" [Started] Thread: video to frames\n");

		#endif

		int active_threads = 0;
		
		Mat retrieved_frame, converted_frame;
		
		video = VideoCapture(multimedia_configuration.video_source);
		
		for(int i = 0;i<4;i++)
		{
			std::thread th(devcoonsStreaming::PushFrameToList, i);
			
			vectorOfThreads.push_back(move(th));
		}
	
		thread_step = 0;
	}
	

	
	void devcoonsStreaming::PushFrameToList(int current)
	{			
		Mat test_frame,retrieved_frame, converted_frame;
				
		for( ;; )
		{
			frames_mutex.lock();
			
			video >> retrieved_frame;
			
			retrieved_frame.convertTo(retrieved_frame, CV_8U);
			
			ImageFormatting(&retrieved_frame,&test_frame);
			
			multimedia_configuration.streaming_format = retrieved_frame.type();
			
			frames_mutex.unlock();
		
			if(retrieved_frame.empty())

				return;

			resize( retrieved_frame, converted_frame, Size(multimedia_configuration.width,multimedia_configuration.height) );
	
			while(frames.size() >= STREAM_BUFFER_SIZE)

				usleep(100000);
				
			while(thread_step!=current) usleep(1000);
			
				frames.push(converted_frame);
									
				thread_step = thread_step < 3? thread_step + 1 : 0;	

					imwrite("aaa.bmp",converted_frame);
		}
	}